<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatformOld\ProductNew;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method productLayerImgByParams(array $params)
 * @method productLayerImgV1ByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取产品弹窗图片
     *
     * @support  int $id 对应类型的id [ require true ]
     * @support  string $type 类型 product_detail 产品详情 package 套餐 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatformOld\DTO\Product\ProductLayerImgDTO
     */
    public static function productLayerImg () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->productLayerImg([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatformOld\DTO\Product\ProductLayerImgDTO"
        );
    }

    /**
     * 获取产品弹窗图片v1
     *
     * @support  int $id 对应类型的id [ require true ]
     * @support  string $type 类型 product_detail 产品详情 package 套餐 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatformOld\DTO\Product\ProductLayerImgDTO
     */
    public static function productLayerImgV1 () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->productLayerImgV1([
                        ]),
            "\Mainto\Bridge\Structs\AppointmentPlatformOld\DTO\Product\ProductLayerImgDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatformOld', 'ProductNew\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatformOld', 'ProductNew\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}