<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatformOld\OrderNew;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getIndexOrderByParams(array $params)
 * @method getIndexOrderV1ByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获得首页订单
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatformOld\DTO\Order\IndexOrderDTO
     */
    public static function getIndexOrder () {
        return self::getClass()->getIndexOrder();
    }

    /**
     * 获得首页订单.v1
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AppointmentPlatformOld\DTO\Order\IndexOrderDTO
     */
    public static function getIndexOrderV1 () {
        return self::getClass()->getIndexOrderV1();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatformOld', 'OrderNew\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatformOld', 'OrderNew\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}