<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatformOld\CompanyShoot;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method companyShootRequirementDetailByParams(array $params)
 * @method addCompanyShootRequirementByParams(array $params)
 */
class CompanyShoot {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取近7天是否添加过 企业拍摄需求
     *
     * @support  string $openId 微信openid [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function companyShootRequirementDetail () {
        return self::getClass()->companyShootRequirementDetail([
        ]);
    }

    /**
     * 添加企业拍摄需求信息
     *
     * @support  string $openId 微信openid [ require true ]
     * @support  string $contractName 联系人姓名 [ require true ]
     * @support  int $contractPhone 联系人手机号 [ require true ]
     * @support  string $companyName 企业名称 [ require true ]
     * @support  string $detail 拍摄需求描述 [ require false ]
     * @support  string $shootPeopleNumType 拍摄人数类型A:0-30,B:30-100,C:100人以上 [ require false ]
     * @support  int $shootCityId 拍摄城市id [ require true ]
     * @support  int $shootStoreId 拍摄门店id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addCompanyShootRequirement () {
        return self::getClass()->addCompanyShootRequirement([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatformOld', 'CompanyShoot\CompanyShoot');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatformOld', 'CompanyShoot\CompanyShoot');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}