<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatformOld\Appointment;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method appointmentLookPhotoDataByParams(array $params)
 * @method enableAppointmentTimeListByParams(array $params)
 * @method setAppointmentTimeByParams(array $params)
 * @method updateAppointmentTimeByParams(array $params)
 * @method cancelAppointmentTimeByParams(array $params)
 * @method allowLookPhotoStoreListByParams(array $params)
 * @method appointmentNeedTimeAndNoticeTimeByParams(array $params)
 * @method appointmentLookPhotoDataV1ByParams(array $params)
 * @method enableAppointmentTimeListV1ByParams(array $params)
 * @method setAppointmentTimeV1ByParams(array $params)
 * @method updateAppointmentTimeV1ByParams(array $params)
 * @method cancelAppointmentTimeV1ByParams(array $params)
 * @method allowLookPhotoStoreListV1ByParams(array $params)
 * @method appointmentNeedTimeAndNoticeTimeV1ByParams(array $params)
 */
class AppointmentLookPhoto {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 预约看片首页
     *
     * @support  string $orderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function appointmentLookPhotoData () {
        return self::getClass()->appointmentLookPhotoData([
        ]);
    }

    /**
     * 可预约看片时间列表
     *
     * @support  int $storeId 门店id [ require true ]
     * @support  string $dateStart 开始日期 [ require true ]
     * @support  string $dateEnd 结束日期 [ require true ]
     * @support  string $orderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function enableAppointmentTimeList () {
        return self::getClass()->enableAppointmentTimeList([
        ]);
    }

    /**
     * 设置预约看片时间
     *
     * @support  string $orderNum 订单编号 [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  string $appointmentTime 预约时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setAppointmentTime () {
        return self::getClass()->setAppointmentTime([
        ]);
    }

    /**
     * 更改预约看片时间
     *
     * @support  string $orderNum 订单编号 [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  string $appointmentTime 预约时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateAppointmentTime () {
        return self::getClass()->updateAppointmentTime([
        ]);
    }

    /**
     * 取消预约看片时间
     *
     * @support  string $orderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelAppointmentTime () {
        return self::getClass()->cancelAppointmentTime([
        ]);
    }

    /**
     * 获取可看片门店
     *
     * @support  string $date 日期 [ require true ]
     * @support  string $orderNum 订单编号 [ require true ]
     * @support  int $cityId 城市id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function allowLookPhotoStoreList () {
        return self::getClass()->allowLookPhotoStoreList([
        ]);
    }

    /**
     * 获取看片时长和预约通知时间
     *
     * @support  string $orderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function appointmentNeedTimeAndNoticeTime () {
        return self::getClass()->appointmentNeedTimeAndNoticeTime([
        ]);
    }

    /**
     * 预约看片首页.v1
     *
     * @support  string $orderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function appointmentLookPhotoDataV1 () {
        return self::getClass()->appointmentLookPhotoDataV1([
        ]);
    }

    /**
     * 可预约看片时间列表.v1
     *
     * @support  int $storeId 门店id [ require true ]
     * @support  string $dateStart 开始日期 [ require true ]
     * @support  string $dateEnd 结束日期 [ require true ]
     * @support  string $orderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function enableAppointmentTimeListV1 () {
        return self::getClass()->enableAppointmentTimeListV1([
        ]);
    }

    /**
     * 设置预约看片时间.v1
     *
     * @support  string $orderNum 订单编号 [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  string $appointmentTime 预约时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setAppointmentTimeV1 () {
        return self::getClass()->setAppointmentTimeV1([
        ]);
    }

    /**
     * 更改预约看片时间.v1
     *
     * @support  string $orderNum 订单编号 [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  string $appointmentTime 预约时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateAppointmentTimeV1 () {
        return self::getClass()->updateAppointmentTimeV1([
        ]);
    }

    /**
     * 取消预约看片时间.v1
     *
     * @support  string $orderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelAppointmentTimeV1 () {
        return self::getClass()->cancelAppointmentTimeV1([
        ]);
    }

    /**
     * 获取可看片门店.v1
     *
     * @support  string $date 日期 [ require true ]
     * @support  string $orderNum 订单编号 [ require true ]
     * @support  int $cityId 城市id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function allowLookPhotoStoreListV1 () {
        return self::getClass()->allowLookPhotoStoreListV1([
        ]);
    }

    /**
     * 获取看片时长和预约通知时间.v1
     *
     * @support  string $orderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function appointmentNeedTimeAndNoticeTimeV1 () {
        return self::getClass()->appointmentNeedTimeAndNoticeTimeV1([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatformOld', 'Appointment\AppointmentLookPhoto');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatformOld', 'Appointment\AppointmentLookPhoto');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}