<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatformOld\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array $params)
 * @method editUserInfoByParams(array $params)
 * @method editUserTagByParams(array $params)
 * @method getProfessionsByParams(array $params)
 * @method getPreferencesByParams(array $params)
 * @method bindEmailByParams(array $params)
 * @method checkSignByParams(array $params)
 * @method sendCouponByParams(array $params)
 * @method setProtocolVersionByParams(array $params)
 * @method feedbackByParams(array $params)
 * @method changePasswordDirectByParams(array $params)
 * @method registerByParams(array $params)
 * @method searchUserByUnionIdByParams(array $params)
 * @method detailV1ByParams(array $params)
 * @method editUserInfoV1ByParams(array $params)
 * @method editUserTagV1ByParams(array $params)
 * @method getProfessionsV1ByParams(array $params)
 * @method getPreferencesV1ByParams(array $params)
 * @method setProtocolVersionV1ByParams(array $params)
 * @method feedbackV1ByParams(array $params)
 * @method changePasswordDirectV1ByParams(array $params)
 * @method forgetUserPasswordV1ByParams(array $params)
 * @method changUserPasswordV1ByParams(array $params)
 */
class User {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 用户详情
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 修改用户信息
     *
     * @support  string $name 用户昵称 [ require false ]
     * @support  string $headSculpture 用户头像 [ require false ]
     * @support  string $birth 用户生日 [ require false ]
     * @support  string $sex 用户性别 [ require false ]
     * @support  int $positionId 职位id [ require false ]
     * @support  int $cityId 城市编号 [ require false ]
     * @support  string $email 邮箱 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editUserInfo () {
        return self::getClass()->editUserInfo([
        ]);
    }

    /**
     * 修改用户标签
     *
     * @support  array $preference 偏好的数组 [ require false ]
     * @support  array $purpose 用途的数组 [ require false ]
     * @support  bool $enablePush 接受推送 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editUserTag () {
        return self::getClass()->editUserTag([
        ]);
    }

    /**
     * 职业列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProfessions () {
        return self::getClass()->getProfessions();
    }

    /**
     * 偏好列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPreferences () {
        return self::getClass()->getPreferences();
    }

    /**
     * 绑定邮箱
     *
     * @support  string $email 邮箱地址 [ require true ]
     * @support  string $code 验证码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindEmail () {
        return self::getClass()->bindEmail([
        ]);
    }

    /**
     * 绑定邮箱校验是否通过验证
     *
     * @param  string $brand 品牌 [ require true ]
     * @param  int $user_id 用户uid [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkSign (string $brand, int $user_id) {
        return self::getClass()->checkSign([
            "brand" => $brand,
            "user_id" => $user_id,
        ]);
    }

    /**
     * 绑定邮箱发放优惠券
     *
     * @param  string $brand 品牌 [ require true ]
     * @param  string $email email [ require true ]
     * @param  int $user_id 用户id [ require true ]
     * @param  string $choose 选择的券 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendCoupon (string $brand, string $email, int $user_id, string $choose) {
        return self::getClass()->sendCoupon([
            "brand" => $brand,
            "email" => $email,
            "user_id" => $user_id,
            "choose" => $choose,
        ]);
    }

    /**
     * 记录预约协议版本
     *
     * @support  int $protocolVersion 预约协议版本 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setProtocolVersion () {
        return self::getClass()->setProtocolVersion([
        ]);
    }

    /**
     * 用户意见反馈
     *
     * @support  string $content 内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function feedback () {
        return self::getClass()->feedback([
        ]);
    }

    /**
     * 更改密码（密码为空）
     *
     * @support  string $password 新密码 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changePasswordDirect () {
        return self::getClass()->changePasswordDirect([
        ]);
    }

    /**
     * 注册
     *
     * @support  int $protocolVersion 预约协议版本 [ require true ]
     * @support  string $phone 手机号 [ require true ]
     * @support  string $captcha 验证码 [ require true ]
     * @support  string $password 密码 [ require true ]
     * @support  string $name 用户昵称 [ require false ]
     * @support  string $headImg 微信头像 [ require false ]
     * @support  string $sex 用户性别 [ require false ]
     * @support  int $channel 渠道号 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function register () {
        return self::getClass()->register([
        ]);
    }

    /**
     * 通过unionId判断用户是否在海马体平台注册过
     *
     * @support  string $unionId unionId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function searchUserByUnionId () {
        return self::getClass()->searchUserByUnionId([
        ]);
    }

    /**
     * 用户详情.v1
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function detailV1 () {
        return self::getClass()->detailV1();
    }

    /**
     * 修改用户信息.v1
     *
     * @support  string $name 用户昵称 [ require false ]
     * @support  string $headSculpture 用户头像 [ require false ]
     * @support  string $birth 用户生日 [ require false ]
     * @support  string $sex 用户性别 [ require false ]
     * @support  int $positionId 职位id [ require false ]
     * @support  int $cityId 城市编号 [ require false ]
     * @support  string $email 邮箱 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editUserInfoV1 () {
        return self::getClass()->editUserInfoV1([
        ]);
    }

    /**
     * 修改用户标签.v1
     *
     * @support  array $preference 偏好的数组 [ require false ]
     * @support  array $purpose 用途的数组 [ require false ]
     * @support  bool $enablePush 接受推送 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editUserTagV1 () {
        return self::getClass()->editUserTagV1([
        ]);
    }

    /**
     * 职业列表.v1
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProfessionsV1 () {
        return self::getClass()->getProfessionsV1();
    }

    /**
     * 偏好列表.v1
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPreferencesV1 () {
        return self::getClass()->getPreferencesV1();
    }

    /**
     * 记录预约协议版本.v1
     *
     * @support  int $protocolVersion 预约协议版本 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setProtocolVersionV1 () {
        return self::getClass()->setProtocolVersionV1([
        ]);
    }

    /**
     * 用户意见反馈.v1
     *
     * @support  string $content 内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function feedbackV1 () {
        return self::getClass()->feedbackV1([
        ]);
    }

    /**
     * 更改密码（密码为空）.v1
     *
     * @support  string $password 新密码 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changePasswordDirectV1 () {
        return self::getClass()->changePasswordDirectV1([
        ]);
    }

    /**
     * 通过验证码更改登录密码.v1
     *
     * @param  string $phone 手机号 [ require true ]
     * @param  string $password 新密码 [ require true ]
     * @param  string $captcha 验证码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function forgetUserPasswordV1 (string $phone, string $password, string $captcha) {
        return self::getClass()->forgetUserPasswordV1([
            "phone" => $phone,
            "password" => $password,
            "captcha" => $captcha,
        ]);
    }

    /**
     * 更改密码.v1
     *
     * @param  string $password 旧密码 [ require true ]
     * @param  string $passwordNew 新密码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changUserPasswordV1 (string $password, string $passwordNew) {
        return self::getClass()->changUserPasswordV1([
            "password" => $password,
            "passwordNew" => $passwordNew,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatformOld', 'User\User');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatformOld', 'User\User');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}