<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatformOld\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getCompleteLookPhotoSaleSkuIdsByParams(array $params)
 * @method saleSkuIdsServiceCompleteByParams(array $params)
 * @method getCompleteLookPhotoSaleSkuIdsV1ByParams(array $params)
 * @method saleSkuIdsServiceCompleteV1ByParams(array $params)
 */
class OrderSalesSku {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取需要确认sku信息
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCompleteLookPhotoSaleSkuIds () {
        return self::getClass()->getCompleteLookPhotoSaleSkuIds([
        ]);
    }

    /**
     * 确认当前订单需要确认的sku信息
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function saleSkuIdsServiceComplete () {
        return self::getClass()->saleSkuIdsServiceComplete([
        ]);
    }

    /**
     * 获取需要确认sku信息.v1
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCompleteLookPhotoSaleSkuIdsV1 () {
        return self::getClass()->getCompleteLookPhotoSaleSkuIdsV1([
        ]);
    }

    /**
     * 确认当前订单需要确认的sku信息.v1
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function saleSkuIdsServiceCompleteV1 () {
        return self::getClass()->saleSkuIdsServiceCompleteV1([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatformOld', 'Order\OrderSalesSku');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatformOld', 'Order\OrderSalesSku');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}