<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatformOld\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method shootingRemindByParams(array $params)
 * @method appointmentRemindByParams(array $params)
 * @method upgradeBirthGiftByParams(array $params)
 * @method repairPhotoCompleteByParams(array $params)
 * @method appointmentLookPhotoByParams(array $params)
 * @method appointmentLookPhotoExpireByParams(array $params)
 * @method orderCompleteByParams(array $params)
 * @method memberPointsChangeByParams(array $params)
 */
class Message {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 支付宝小程序 提前一天-拍摄预约提醒推送
     *
     * @support  string $reviewTime 预约时间 [ require true ]
     * @support  array $productNames 拍摄内容 [ require true ]
     * @support  string $storeName 拍摄门店名称 [ require true ]
     * @support  string $storeAddress 拍摄门店地址 [ require true ]
     * @support  int $userId himoUserId [ require true ]
     * @support  string $page 跳转url [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function shootingRemind () {
        return self::getClass()->shootingRemind([
        ]);
    }

    /**
     * 支付宝小程序  预约成功通知,下单成功通知
     *
     * @support  string $userName 用户姓名 [ require true ]
     * @support  string $storeName 拍摄门店名称 [ require true ]
     * @support  string $reviewTime 预约时间 [ require true ]
     * @support  array $productNames 拍摄内容 [ require true ]
     * @support  string $realMoney 已付金额 [ require true ]
     * @support  int $userId himoUserId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function appointmentRemind () {
        return self::getClass()->appointmentRemind([
        ]);
    }

    /**
     * 支付宝小程序 免费升级礼遇,签到送券
     *
     * @support  string $couponStr 权益内容 [ require true ]
     * @support  int $userId himoUserId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function upgradeBirthGift () {
        return self::getClass()->upgradeBirthGift([
        ]);
    }

    /**
     * 支付宝小程序  修片完成,通知看片
     *
     * @support  string $userName 用户姓名 [ require true ]
     * @support  string $reviewTime 预约时间 [ require true ]
     * @support  string $storeName 拍摄门店名称 [ require true ]
     * @support  string $storePhone 拍摄门店电话 [ require true ]
     * @support  string $orderNum 订单编号 [ require true ]
     * @support  int $userId himoUserId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function repairPhotoComplete () {
        return self::getClass()->repairPhotoComplete([
        ]);
    }

    /**
     * 支付宝小程序 预约看片,预约成功通知
     *
     * @support  string $userName 顾客姓名 [ require true ]
     * @support  string $storeName 拍摄门店 [ require true ]
     * @support  string $storeAddress 门店地址 [ require true ]
     * @support  string $reviewTime 预约时间 [ require true ]
     * @support  int $userId himoUserId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function appointmentLookPhoto () {
        return self::getClass()->appointmentLookPhoto([
        ]);
    }

    /**
     * 支付宝小程序 预约看片,预约失效通知
     *
     * @support  string $orderNum 订单编号 [ require true ]
     * @support  string $storeName 拍摄门店 [ require true ]
     * @support  string $reviewTime 预约时间 [ require true ]
     * @support  int $userId himoUserId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function appointmentLookPhotoExpire () {
        return self::getClass()->appointmentLookPhotoExpire([
        ]);
    }

    /**
     * 支付宝小程序 看片完成、发送订单完成通知
     *
     * @support  string $orderNum 订单编号 [ require true ]
     * @support  int $userId himoUserId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderComplete () {
        return self::getClass()->orderComplete([
        ]);
    }

    /**
     * 支付宝小程序 用户会员积分变更提醒
     *
     * @support  string $userName 会员姓名 [ require true ]
     * @support  string $userPhone 会员账号 [ require true ]
     * @support  string $content 变动内容 [ require true ]
     * @support  int $userId himoUserId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function memberPointsChange () {
        return self::getClass()->memberPointsChange([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatformOld', 'MessageQueue\Message');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatformOld', 'MessageQueue\Message');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}