<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatformOld\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method sendWxChoosePoseTipsByParams(array $params)
 * @method sendWxChoosePoseTipsOneHourByParams(array $params)
 */
class ChoosePose {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 发送拍前选造型提醒消息
     *
     * @support  array $orderInfo 订单信息 [ require true ]
     * @support  string $type 类型 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendWxChoosePoseTips () {
        return self::getClass()->sendWxChoosePoseTips([
        ]);
    }

    /**
     * 发送拍前选造型提醒消息 当天前一个小时
     *
     * @support  int $orderId 订单ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendWxChoosePoseTipsOneHour () {
        return self::getClass()->sendWxChoosePoseTipsOneHour([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatformOld', 'MessageQueue\ChoosePose');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatformOld', 'MessageQueue\ChoosePose');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}