<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatformOld\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method bindProductCardByParams(array $params)
 * @method productCardListByParams(array $params)
 * @method availableProductCardListByParams(array $params)
 */
class ProductCard {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 用户绑定产品卡
     * @deprecated
     *
     * @support  string $productCardCode 兑换码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindProductCard () {
        return self::getClass()->bindProductCard([
        ]);
    }

    /**
     * 产品卡列表
     *
     * @support  string $statusType 产品卡状态类型  [ require false ]
     * @support  string $status 产品卡状态 [ require false ]
     * @support  int $page 页数  [ require false ]
     * @support  int $pageSize 页码数  [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function productCardList () {
        return self::getClass()->productCardList([
        ]);
    }

    /**
     * 获取产品可用产品卡列表
     *
     * @support  array $productIds 产品id [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function availableProductCardList () {
        return self::getClass()->availableProductCardList([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatformOld', 'Preferential\ProductCard');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatformOld', 'Preferential\ProductCard');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}