<?php
namespace Mainto\Bridge\Invokes\AbTest\Ab;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method isEnableByParams(array|\Mainto\Bridge\Structs\AbTest\Ab\Service\Cmd\AbCmd $params)
 */
class Enable {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * isEnable
     *
     * @var  \Mainto\Bridge\Structs\AbTest\Ab\Service\Cmd\AbCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function isEnable (\Mainto\Bridge\Structs\AbTest\Ab\Service\Cmd\AbCmd $cmd) {
        return self::getClass()->isEnable($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AbTest', 'Ab\Enable');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AbTest', 'Ab\Enable');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}