<?php
namespace Mainto\Bridge\Invokes\AbTest\Ab;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|\Mainto\Bridge\Structs\AbTest\Ab\Service\Cmd\FeatureCmd $params)
 * @method infoByParams(array $params)
 * @method updateByParams(array|\Mainto\Bridge\Structs\AbTest\Ab\Service\Cmd\FeatureCmd $params)
 * @method enableByParams(array $params)
 * @method disableByParams(array $params)
 * @method archiveByParams(array $params)
 */
class Feature {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * create
     *
     * @var  \Mainto\Bridge\Structs\AbTest\Ab\Service\Cmd\FeatureCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AbTest\Ab\DTO\FeatureDTO
     */
    public static function create (\Mainto\Bridge\Structs\AbTest\Ab\Service\Cmd\FeatureCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->create($cmd),
            "\Mainto\Bridge\Structs\AbTest\Ab\DTO\FeatureDTO"
        );
    }


    /**
     * info
     *
     * @param  string $featureName 特征名称标识 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AbTest\Ab\DTO\FeatureDTO
     */
    public static function info (string $featureName = '') {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->info([
                            "featureName" => $featureName,
                        ]),
            "\Mainto\Bridge\Structs\AbTest\Ab\DTO\FeatureDTO"
        );
    }

    /**
     * update
     *
     * @var  \Mainto\Bridge\Structs\AbTest\Ab\Service\Cmd\FeatureCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\AbTest\Ab\DTO\FeatureDTO
     */
    public static function update (\Mainto\Bridge\Structs\AbTest\Ab\Service\Cmd\FeatureCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->update($cmd),
            "\Mainto\Bridge\Structs\AbTest\Ab\DTO\FeatureDTO"
        );
    }


    /**
     * enable
     *
     * @param  string $featureName 特征名称标识 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function enable (string $featureName = '') {
        return self::getClass()->enable([
            "featureName" => $featureName,
        ]);
    }

    /**
     * disable
     *
     * @param  string $featureName 特征名称标识 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function disable (string $featureName = '') {
        return self::getClass()->disable([
            "featureName" => $featureName,
        ]);
    }

    /**
     * archive
     *
     * @param  string $featureName 特征名称标识 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function archive (string $featureName = '') {
        return self::getClass()->archive([
            "featureName" => $featureName,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AbTest', 'Ab\Feature');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AbTest', 'Ab\Feature');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}