<?php
namespace Mainto\Bridge\Invokes\AbTest\Ab;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getVariantByParams(array|\Mainto\Bridge\Structs\AbTest\Ab\Service\Cmd\AbCmd $params)
 */
class Variant {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getVariant
     *
     * @var  \Mainto\Bridge\Structs\AbTest\Ab\Service\Cmd\AbCmd $cmd
     * @throws  \Exception
     * @return  string
     */
    public static function getVariant (\Mainto\Bridge\Structs\AbTest\Ab\Service\Cmd\AbCmd $cmd) {
        return self::getClass()->getVariant($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AbTest', 'Ab\Variant');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AbTest', 'Ab\Variant');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}