<?php
namespace Mainto\Bridge\Invokes\AbTest\Ab\Feature;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addByParams(array|\Mainto\Bridge\Structs\AbTest\Ab\Cmd\FeatureShopsCmd $params)
 * @method removeByParams(array|\Mainto\Bridge\Structs\AbTest\Ab\Cmd\FeatureShopsCmd $params)
 */
class Shop {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * add
     *
     * @var  \Mainto\Bridge\Structs\AbTest\Ab\Cmd\FeatureShopsCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function add (\Mainto\Bridge\Structs\AbTest\Ab\Cmd\FeatureShopsCmd $cmd) {
        return self::getClass()->add($cmd);
    }


    /**
     * remove
     *
     * @var  \Mainto\Bridge\Structs\AbTest\Ab\Cmd\FeatureShopsCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function remove (\Mainto\Bridge\Structs\AbTest\Ab\Cmd\FeatureShopsCmd $cmd) {
        return self::getClass()->remove($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AbTest', 'Ab\Feature\Shop');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AbTest', 'Ab\Feature\Shop');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}