<?php
namespace Mainto\Bridge\Invokes\AbTest\Ab;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method webhookByParams(array|\Mainto\Bridge\Structs\AbTest\Ab\Cmd\WebhookCmd $params)
 */
class Notify {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * webhook
     *
     * @var  \Mainto\Bridge\Structs\AbTest\Ab\Cmd\WebhookCmd $cmd
     * @throws  \Exception
     * @return  string
     */
    public static function webhook (\Mainto\Bridge\Structs\AbTest\Ab\Cmd\WebhookCmd $cmd) {
        return self::getClass()->webhook($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AbTest', 'Ab\Notify');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AbTest', 'Ab\Notify');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}