<?php


namespace Mainto\JsonMapper\Mapper;


class Context {
    public ?Context $parent;
    /**
     * @var mixed
     */
    private $data;

    private $value;

    public function __construct ($value, $parent = null) {
        $this->parent = $parent;
        $this->data = $value;
    }

    public function data() {
        return $this->data;
    }

    public function setValue($value): void {
        $this->value = $value;
    }

    public function value() {
        return $this->value;
    }

    public function dataDecode(): void {
        if (is_string($this->data)) {
            $this->data = json_decode($this->data , true);
        }
    }
}