<?php

if (!function_exists('str_contains')) {
    function str_contains ($haystack, $needles): bool {
        foreach ((array)$needles as $needle) {
            if ($needle !== '' && mb_strpos($haystack, $needle) !== false) {
                return true;
            }
        }

        return false;
    }
}

if (!function_exists('str_ends_with')) {
    function str_ends_with ($haystack, $needles): bool {
        foreach ((array)$needles as $needle) {
            if (
                $needle !== '' && $needle !== null
                && substr($haystack, -strlen($needle)) === (string)$needle
            ) {
                return true;
            }
        }

        return false;
    }
}

if (!function_exists('str_starts_with')) {
    function str_starts_with ($haystack, $needles): bool {
        foreach ((array) $needles as $needle) {
            if ((string) $needle !== '' && strncmp($haystack, $needle, strlen($needle)) === 0) {
                return true;
            }
        }

        return false;
    }
}

if (!function_exists('str_studly')) {
    function str_studly ($value) {
        static $studlyCache = [];
        $key = $value;

        if (isset($studlyCache[$key])) {
            return $studlyCache[$key];
        }

        $value = ucwords(str_replace(['-', '_'], ' ', $value));

        return $studlyCache[$key] = str_replace(' ', '', $value);
    }
}

if (!function_exists('to_array_map')) {
    function to_array_map (array $var): array {
        return array_map_with_Key(function ($value, $key) {
            if (method_exists($value, 'toArray')) {
                return [$key => $value->toArray()];
            } elseif (is_array($value)) {
                return [$key => to_array_map($value)];
            } else {
                return [$key => $value];
            }
        }, $var);
    }
}

if (!function_exists('array_map_with_Key')) {
    function array_map_with_Key (callable $callback, array $var): array {
        $map = [];
        foreach ($var as $key => $value) {
            $map += $callback($value, $key);
        }

        return $map;
    }
}

if (! function_exists('class_basename')) {
    /**
     * Get the class "basename" of the given object / class.
     *
     * @param  string|object  $class
     * @return string
     */
    function class_basename($class): string {
        $class = is_object($class) ? get_class($class) : $class;

        return basename(str_replace('\\', '/', $class));
    }
}


if (!function_exists('to_array')) {
    function to_array (array $var): array {
        return array_map(function ($value) {
            if (method_exists($value, 'toArray')) {
                return $value->toArray();
            } elseif (is_array($value)) {
                return to_array($value);
            } else {
                return $value;
            }
        }, $var);
    }
}



