<?php
/**
 * Created by PhpStorm.
 * User: PHPStorm
 * Date: 18-10-22
 * Time: 下午3:17
 */

namespace Mainto\RpcServer\Providers;

use Doctrine\Common\Annotations\AnnotationRegistry;
use Illuminate\Support\ServiceProvider;
use Mainto\RpcServer\Command\RpcAgent;
use Mainto\RpcServer\Command\RpcCluster;
use Mainto\RpcServer\Command\RpcMakeControllerTestClass;
use Mainto\RpcServer\RpcServer\RpcRouter;
use Mainto\RpcServer\RpcUtil\RpcAnnotationLoader;
use Mainto\RpcServer\RpcUtil\Tool\RpcLog;

class RpcServerServiceProvider extends ServiceProvider {
    /**
     * Bootstrap the application services.
     *
     * @return void
     */
    public function boot () {
        if ($this->app->runningInConsole()) {

            $this->publishes([
                __DIR__.'/../config.php' => config_path('rpc-server.php'),
            ], 'config');
        }
    }

    /**
     * Register the application services.
     *
     * @return void
     */
    public function register () {
        $this->mergeConfigFrom(__DIR__.'/../config.php', 'rpc-server');

        $this->app->bind('command.rpc.agent', RpcAgent::class);
        $this->app->bind('command.rpc.cluster', RpcCluster::class);
        $this->app->bind('command.rpc.make.controller_test', RpcMakeControllerTestClass::class);

        $this->commands([
            'command.rpc.agent',
            'command.rpc.cluster',
            'command.rpc.make.controller_test',
        ]);

        $this->app->singleton('rpc-server', function () {
            return RpcRouter::getInstance();
        });

        $this->app->singleton('rpc-log', function () {
            return RpcLog::getInstance();
        });

        $loader = new RpcAnnotationLoader();
        AnnotationRegistry::registerLoader([$loader, "loadClass"]);
    }
}
