<?php
/**
 * Created by PhpStorm.
 * User: jiuli
 * Date: 2018/3/18
 * Time: 上午11:50
 */

namespace Mainto\RpcServer\RpcServer;


use Mainto\RpcServer\RpcServer\ContextTrait\HeaderTrait;
use Mainto\RpcServer\RpcServer\ContextTrait\ParamTrait;
use Mainto\RpcServer\RpcServer\ContextTrait\RpcMessageTrait;
use Mainto\RpcServer\RpcServer\ContextTrait\RpcReturnTrait;
use Mainto\RpcServer\RpcServer\ContextTrait\RpcUrlTrait;
use Mainto\RpcServer\RpcServer\ContextTrait\SessionTrait;
use Mainto\RpcServer\RpcUtil\RpcBlock;

class RpcContext {
    use ParamTrait;
    use RpcUrlTrait;
    use RpcMessageTrait;
    use RpcReturnTrait;
    use SessionTrait;
    use HeaderTrait;

    private $requestId;
    private $rpcBlock = null;
    private $paramMap = null;
    private $rawMode = false;

    /**
     * RpcRequest constructor.
     * @param RpcInvoke $invoke
     * @param $requestId
     * @param array $params
     * @param RpcBlock $block
     * @param $rawMode
     */
    public function __construct (RpcInvoke $invoke, $requestId, array $params, RpcBlock $block, $rawMode) {
        $this->requestInvoke = $invoke;
        $this->requestId = $requestId;
        $this->requestParams = collect($params);
        $this->rpcBlock = $block;
        $this->session_id = $this->getSessionId();
        $this->rawMode = $rawMode;
    }

    /**
     * 是否是 Raw 模式
     * @return bool
     */
    public function isRawMode (): bool {
        return $this->rawMode;
    }
}