<?php
/**
 * Created by PhpStorm.
 * User: jiuli
 * Date: 2018/3/19
 * Time: 下午6:12
 */

namespace Mainto\RpcServer\RpcClient;


use Workerman\Connection\ConnectionInterface;

/**
 * 兼容 Workerman 的 Rpc 包装类
 * Class RpcClientSocket
 * @package Mainto\RpcServer\RpcClient
 */
class RpcClientSocket extends ConnectionInterface {
    /**
     * Socket
     *
     * @var \Socket\Raw\Socket
     */
    private $socket;

    /**
     * RpcClientSocket constructor.
     * @param \Socket\Raw\Socket $socket
     */
    public function __construct (\Socket\Raw\Socket $socket) { $this->socket = $socket; }


    /**
     * Sends data on the connection.
     *
     * @param string $send_buffer
     * @return boolean
     */
    public function send ($send_buffer) {
        return $this->socket->write($send_buffer);
    }

    /**
     * Get remote IP.
     *
     * @return string
     */
    public function getRemoteIp () {

    }

    /**
     * Get remote port.
     *
     * @return int
     */
    public function getRemotePort () {

    }

    /**
     * Get remote address.
     *
     * @return string
     */
    public function getRemoteAddress () {
        // TODO: Implement getRemoteAddress() method.
    }

    /**
     * Get local IP.
     *
     * @return string
     */
    public function getLocalIp () {
        // TODO: Implement getLocalIp() method.
    }

    /**
     * Get local port.
     *
     * @return int
     */
    public function getLocalPort () {
        // TODO: Implement getLocalPort() method.
    }

    /**
     * Get local address.
     *
     * @return string
     */
    public function getLocalAddress () {
        // TODO: Implement getLocalAddress() method.
    }

    /**
     * Is ipv4.
     *
     * @return bool
     */
    public function isIPv4 () {
        // TODO: Implement isIPv4() method.
    }

    /**
     * Is ipv6.
     *
     * @return bool
     */
    public function isIPv6 () {
        // TODO: Implement isIPv6() method.
    }

    /**
     * Close connection.
     *
     * @param $data
     * @return void
     */
    public function close ($data = null) {
        if ($data != null) {
            $this->socket->write($data);
        }
        $this->socket->close();
    }
}