<?php
/**
 * Created by PhpStorm.
 * User: jiuli
 * Date: 2018/4/9
 * Time: 下午4:24
 */

namespace Mainto\RpcServer\RpcUtil\Stream;

class RpcStreamControlBlock {
    protected $action;
    protected $streamId;
    protected $payload;
    protected $payloadType;

    /**
     * RpcStreamControlBlock constructor.
     *
     * @param string $action
     * @param string $streamId
     * @param null $payload
     * @param int $payloadType
     */
    private function __construct (string $action = "", string $streamId = "", $payload = null, $payloadType = 0) {
        $this->action = $action;
        $this->streamId = $streamId;
        $this->payload = $payload;
        $this->payloadType = $payloadType;
    }

    /**
     * @param array $data
     * @return RpcStreamControlBlock
     */
    public static function getInstance ($data) {
        return new RpcStreamControlBlock($data['a'], $data['i'], $data['p'], $data['t']);
    }

    /**
     * @param string $action
     * @param string $streamId
     * @param mixed $payload
     * @param int $payloadType
     * @return RpcStreamControlBlock
     */
    public static function getInstanceByValue (string $action, string $streamId, $payload, int $payloadType) {
        return new RpcStreamControlBlock($action, $streamId, $payload, $payloadType);
    }

    /**
     * @return string
     */
    public function getAction (): string {
        return $this->action;
    }

    /**
     * @return string
     */
    public function getStreamId (): string {
        return $this->streamId;
    }

    /**
     * @return null
     */
    public function getPayload () {
        return $this->payload;
    }

    /**
     * @return int
     */
    public function getPayloadType (): int {
        return $this->payloadType;
    }

    public function getData () {
        return [
            'a' => $this->action,
            'i' => $this->streamId,
            't' => $this->payloadType,
            'p' => $this->payload,
        ];
    }
}