<?php
/**
 * Created by PhpStorm.
 * User: PHPStorm
 * Date: 18-12-23
 * Time: 下午4:46
 */

namespace Mainto\RpcServer\RpcUtil;

use RuntimeException;
use Workerman\Connection\ConnectionInterface;

/**
 * 兼容 Workerman 的 Rpc 包装类
 * Class RpcSocket
 * @package App\Helper\RpcUtil
 */
class RpcSocket extends ConnectionInterface {
    /**
     * Socket
     */
    private $socket;
    private $server;
    private $port;

    /**
     * RpcSocket constructor.
     * @param $server
     * @param $port
     */
    public function __construct ($server, $port) {
        $this->server = $server;
        $this->port = $port;
        $this->socket = @socket_create(AF_INET, SOCK_STREAM, SOL_TCP);

        if (!@socket_connect($this->socket, $server, $port)) {
            throw new RuntimeException("connect to {$server}:{$port} error");
        }
    }


    /**
     *  Sends data on the connection.
     *
     * @param mixed $send_buffer
     * @return int
     */
    public function send ($send_buffer) {
        return socket_write($this->socket, RpcProtocol::encode($send_buffer, $this));
    }

    /**
     * read data on the connection.
     *
     * @param int $maxLength
     * @return string
     */
    public function read ($maxLength = 10240) {
        return socket_read($this->socket, $maxLength);
    }

    /**
     * Get remote IP.
     *
     * @return string
     */
    public function getRemoteIp () {

    }

    /**
     * Get remote port.
     *
     * @return int
     */
    public function getRemotePort () {

    }

    /**
     * Get remote address.
     *
     * @return string
     */
    public function getRemoteAddress () {
        // TODO: Implement getRemoteAddress() method.
    }

    /**
     * Get local IP.
     *
     * @return string
     */
    public function getLocalIp () {
        // TODO: Implement getLocalIp() method.
    }

    /**
     * Get local port.
     *
     * @return int
     */
    public function getLocalPort () {
        // TODO: Implement getLocalPort() method.
    }

    /**
     * Get local address.
     *
     * @return string
     */
    public function getLocalAddress () {
        // TODO: Implement getLocalAddress() method.
    }

    /**
     * Is ipv4.
     *
     * @return bool
     */
    public function isIPv4 () {
        // TODO: Implement isIPv4() method.
    }

    /**
     * Is ipv6.
     *
     * @return bool
     */
    public function isIPv6 () {
        // TODO: Implement isIPv6() method.
    }

    /**
     * Close connection.
     *
     * @param $data
     * @return void
     */
    public function close ($data = null) {
        if ($data != null) {
            $this->send($data);
        }
        @socket_close($this->socket);
    }
}
