<?php
/**
 * Created by PhpStorm.
 * User: jiuli
 * Date: 2018/7/30
 * Time: 下午2:21
 */

namespace Mainto\RpcServer\RpcUtil;


use Mainto\RpcServer\RpcUtil\Tool\AgentToolHelper;
use Ramsey\Uuid\Uuid;

class RpcMessageQueue {
    private const QUEUE_NAME = "micro-default-queue";
    private const EXCHANGE_NAME = "micro-default-exchange";

    public const PERSISTENT = 'persistent';
    public const TRANSIENT = 'transient';

    /**
     * @var RpcMessageQueue
     */
    private static $instance;

    /**
     * @var string
     */
    private $serviceName = "";

    /**
     * RpcMQ constructor.
     */
    public function __construct () {
        $this->serviceName = config('rpc-server.service_name');
    }

    /**
     * get instance
     *
     * @return RpcMessageQueue
     */
    public static function getInstance () {
        if (!self::$instance) {
            self::$instance = new RpcMessageQueue();
        }

        return self::$instance;
    }

    /**
     * 发送消息到 MessageQueue
     * @param string $recvName 接受消息名
     * @param array $param     发送的消息
     * @param string $mode     持久化模式 [默认持久化]
     * @throws \Exception
     */
    public function addMessageToQueue (string $recvName, array $param = [], $mode = self::PERSISTENT) {
        $param['_uuid_'] = Uuid::uuid4();

        AgentToolHelper::pushToAgent('', self::QUEUE_NAME, false, false, [
            'body'          => json_encode($param),
            'content_type'  => "text/json",
            'app_id'        => $this->serviceName,
            'delivery_mode' => $mode,
            'type'          => $recvName,
        ]);
    }

    /**
     * 发送消息到 WebSocket
     * @param string $room_name 接受房间名
     * @param string $client_id 接受客户端ID
     * @param string $content   发送的消息
     * @param string $mode      持久化模式 [默认非持久化]
     */
    public function addMessageToWebSocket (string $room_name, string $client_id, string $content, $mode = self::PERSISTENT) {
        AgentToolHelper::pushToAgent('', self::QUEUE_NAME, false, false, [
            'body'          => $content,
            'app_id'        => $this->serviceName,
            'type'          => 'ws_send',
            'content_type'  => "text/json",
            'delivery_mode' => $mode,
            'headers'       => json_encode([
                "RoomName" => $room_name,
                "UserId"   => $client_id,
            ]),
        ]);
    }

    /**
     * 发送延迟消息
     * @param int $delayTime   延迟时间 [单位: ms]
     * @param string $recvName 接受消息名
     * @param array $param     发送的消息
     * @param string $mode     持久化模式 [默认持久化]
     * @throws \Exception
     */
    public function sendDelayMessage (int $delayTime, string $recvName, array $param = [], $mode = self::PERSISTENT) {
        $param['_uuid_'] = Uuid::uuid4();

        AgentToolHelper::pushToAgent(self::EXCHANGE_NAME, '', false, false, [
            'body'          => json_encode($param),
            'app_id'        => $this->serviceName,
            'type'          => $recvName,
            'content_type'  => "text/json",
            'delivery_mode' => $mode,
            'headers'       => json_encode([
                "x-delay" => $delayTime,
            ]),
        ]);
    }
}