<?php
/**
 * Created by PhpStorm.
 * User: jiuli
 * Date: 2018/4/7
 * Time: 下午3:20
 */

namespace Mainto\RpcServer\RpcServer\ContextTrait;

use Mainto\RpcServer\RpcUtil\RpcSessionBag;

trait SessionTrait {
    private $session_id = null;

    /**
     * @var RpcSessionBag
     */
    private $sessionPack;

    /**
     * 获得当前 Session
     * @return RpcSessionBag
     * @throws \Exception
     */
    public function getSession () {
        if (!$this->sessionPack) {
            $this->sessionPack = new RpcSessionBag($this->session_id);
            $this->sessionPack->start();
        }

        return $this->sessionPack;
    }

    /**
     * 保存当前 Session
     * @throws \Exception
     */
    public function saveSession () {
        if ($this->sessionPack) {
            $this->sessionPack->save();
        }
    }
}