<?php
/**
 * Created by PhpStorm.
 * User: PHPStorm
 * Date: 18-12-23
 * Time: 下午4:43
 */

namespace Mainto\RpcServer\Command;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use Mainto\RpcServer\RpcServer\RpcServerClusterMode;
use Mainto\RpcServer\RpcUtil\Tool\AgentToolHelper;

class RpcCluster extends Command {
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'rpc:cluster {--server=} {--port=} {--tool-port=} {--key=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'RPC Cluster Command';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct () {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @throws \Throwable
     */
    public function handle () {
        $server = $this->option('server');
        $port = $this->option('port');
        $key = $this->option('key');

        AgentToolHelper::setToolPort($this->option('tool-port'));

        Log::info("worker pid: ".getmypid());

        return RpcServerClusterMode::exec($server, $port, $key);
    }
}
