<?php
/**
 * Created by PhpStorm.
 * User: PHPStorm
 * Date: 19-2-20
 * Time: 下午4:13
 */

namespace Mainto\RpcServer\Command;


use Illuminate\Console\Command;

class RpcAgent extends Command {
    const AgentUrl = "https://s3.code.hzmantu.com/";

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'rpc:agent {option?}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'RPC Agent Command';

    /**
     * 可用的 Command
     * @var array
     */
    private $commands = [
        'start',
        'download',
    ];

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct () {
        parent::__construct();
    }

    /**
     * download agent
     *
     * @return string
     */
    private function initAgent () {
        $agentFile = __DIR__."/../agent_config";
        if (!file_exists($agentFile)) {
            dd("no agent config: {$agentFile}");
        }

        $curOS = strtolower(PHP_OS);
        $curArch = php_uname("m");

        if (!in_array($curOS, ["linux", "darwin"])) {
            dd("current not support os {$curOS}");
        }

        if ($curArch != "x86_64") {
            dd("current not support arch {$curArch}");
        }

        $config = trim(file_get_contents($agentFile));
        $runHash = substr(md5($config), 0, 8);
        $runFile = __DIR__."/../../bin/agent-{$runHash}";

        if (!file_exists($runFile)) {
            $agentUrl = self::AgentUrl."{$config}/{$curOS}/amd64/agent";

            print "download agent from {$agentUrl}...\n";

            $data = file_get_contents($agentUrl);
            $md5 = file_get_contents("{$agentUrl}.md5");

            if (md5($data) != substr($md5, 0, 32)) {
                dd("download agent is invalid, please try again later.");
            }

            if (!file_exists(dirname($runFile)) && !mkdir(dirname($runFile), 0777, true)) {
                dd("mkdir bin dir error");
            }

            if (!file_put_contents($runFile, $data)) {
                dd("write agent error");
            }

            if (!chmod($runFile, 0777)) {
                dd("chmod agent error");
            }

            print "download success.\n";
        }

        $agentConf = array_merge(config('rpc-server.agent'), [
            'service_dir'      => base_path(),
            'watch_reload_dir' => app_path(),
            'log_file_dir'     => storage_path("logs/agent").'/$year-$month-$day',
            'core_file_path'   => storage_path("logs/core"),

            'rabbitmq_enable'   => config('rpc-server.rabbit_mq.enable'),
            'rabbitmq_host'     => config('rpc-server.rabbit_mq.host'),
            'rabbitmq_port'     => config('rpc-server.rabbit_mq.port'),
            'rabbitmq_username' => config('rpc-server.rabbit_mq.username'),
            'rabbitmq_password' => config('rpc-server.rabbit_mq.password'),
        ]);

        if (!file_exists($agentConf['core_file_path'])) {
            mkdir($agentConf['core_file_path'], 0777, true);
        }

        $addPHPCommandLine = function (...$args) use (&$agentConf) {
            if (isset($agentConf['php_command_line'])) {
                $curCommandLine = json_decode($agentConf['php_command_line'], true);
                $curCommandLine = array_merge($curCommandLine, $args);
                $agentConf['php_command_line'] = json_encode($curCommandLine);
            } else {
                $agentConf['php_command_line'] = json_encode($args);
            }
        };

        if ($otherConfig = get_cfg_var('cfg_file_path')) {
            $addPHPCommandLine('-c', $otherConfig);
        }

        foreach ($agentConf as $key => $value) {
            $keyName = strtoupper("php_agent_{$key}");
            if (!getenv($keyName)) {
                putenv($keyName.'='.($value === true ? "true" : $value));
            }
        }

        return $runFile;
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle () {
        $command = $this->argument('option');

        if (!$command || !in_array($command, $this->commands)) {
            $this->comment('Usage: php artisan rpc:agent {start}');
            return 1;
        }

        $runFile = $this->initAgent();

        switch ($command) {
            case "start":
                system($runFile);
                break;
            case "download":
                break;
        }

        return 0;
    }
}
