<?php
/**
 * Created by PhpStorm.
 * User: jiuli
 * Date: 2018/3/19
 * Time: 下午4:02
 */

namespace Mainto\RpcServer\RpcUtil;


use Mainto\RpcServer\RpcUtil\Block\CheckBlock;
use Mainto\RpcServer\RpcUtil\Block\ErrorReturnBlock;
use Mainto\RpcServer\RpcUtil\Block\InvokeControlBlock;
use Mainto\RpcServer\RpcUtil\Block\MessageInvokeControlBlock;
use Mainto\RpcServer\RpcUtil\Block\SuccessReturnBlock;
use Mainto\RpcServer\RpcUtil\Block\UrlInvokeControlBlock;

abstract class RpcBlock {
    /**
     * 缓存的复用对象
     * @var RpcBlock[]
     */
    protected static $blockInstance = null;
    private static $blockMap = [
        InvokeControlBlock::class,
        UrlInvokeControlBlock::class,
        MessageInvokeControlBlock::class,
        SuccessReturnBlock::class,
        ErrorReturnBlock::class,
        CheckBlock::class,
    ];
    protected $type;
    protected $action;

    /**
     * RpcBlock constructor.
     * @param string $type
     * @param string $action
     */
    public function __construct (string $type = "", string $action = "") {
        $this->type = $type;
        $this->action = $action;
    }

    /**
     * 尝试解包一个信息
     * @param $needType
     * @param $data
     * @return RpcBlock
     */
    public static function make ($needType, $data): RpcBlock {
        if (self::$blockInstance === null) {
            self::$blockInstance = [];

            foreach (self::$blockMap as $blockClass) {
                $class = new $blockClass();
                if ($class instanceof RpcBlock) {
                    self::$blockInstance[$class->getPayloadType()] = $class;
                }
            }
        }

        if (isset(self::$blockInstance[$needType])) {
            $blockClass = self::$blockInstance[$needType];
            $blockClass->setArray($data);
            return $blockClass;
        }

        return null;
    }

    /**
     * 获取载荷类型
     * @return int
     */
    public abstract function getPayloadType (): int;

    /**
     * 设置当前数据
     * @param array $data
     */
    protected function setArray (array $data) {
        $this->type = $data['t'] ?? '';
        $this->action = $data['a'] ?? '';
    }

    /**
     * 将当前Block转为数组
     * @return array
     */
    public function toArray (): array {
        return [
            't' => $this->type,
            'a' => $this->action,
        ];
    }

    /**
     * @return string
     */
    public function getType (): string {
        return $this->type;
    }

    /**
     * @return string
     */
    public function getAction (): string {
        return $this->action;
    }
}