<?php
/**
 * Created by PhpStorm.
 * User: PHPStorm
 * Date: 18-10-22
 * Time: 下午3:17
 */

namespace Mainto\RpcServer\Providers;

use Doctrine\Common\Annotations\AnnotationRegistry;
use Illuminate\Support\ServiceProvider;
use Mainto\RpcServer\Command\RpcAgent;
use Mainto\RpcServer\Command\RpcBridgeDump;
use Mainto\RpcServer\Command\RpcCluster;
use Mainto\RpcServer\Command\RpcDocClean;
use Mainto\RpcServer\Command\RpcDocUpload;
use Mainto\RpcServer\Command\RpcJsSdkDump;
use Mainto\RpcServer\Command\RpcMakeControllerTestClass;
use Mainto\RpcServer\Command\RpcMockDump;
use Mainto\RpcServer\Command\RpcSdkDump;
use Mainto\RpcServer\RpcServer\RpcRouter;
use Mainto\RpcServer\RpcUtil\RpcAnnotationLoader;
use Mainto\RpcServer\RpcUtil\Tool\RpcLog;

class RpcServerServiceProvider extends ServiceProvider {
    /**
     * Bootstrap the application services.
     *
     * @return void
     */
    public function boot () {
        if ($this->app->runningInConsole()) {

            $this->publishes([
                __DIR__.'/../config.php' => config_path('rpc-server.php'),
            ], 'config');
        }
    }

    /**
     * Register the application services.
     *
     * @return void
     */
    public function register () {
        $this->mergeConfigFrom(__DIR__.'/../config.php', 'rpc-server');
        $this->app['config']->set('view.paths', array_merge($this->app['config']->get('view.paths'), [
            __DIR__.'/../Command/dump-template',
        ]));

        $this->app->bind('command.rpc.agent', RpcAgent::class);
        $this->app->bind('command.rpc.cluster', RpcCluster::class);
        $this->app->bind('command.rpc.dump.bridge', RpcBridgeDump::class);
        $this->app->bind('command.rpc.dump.mock', RpcMockDump::class);
        $this->app->bind('command.rpc.dump.sdk', RpcSdkDump::class);
        $this->app->bind('command.rpc.make.controller_test', RpcMakeControllerTestClass::class);
        $this->app->bind('command.rpc.dump.js-sdk', RpcJsSdkDump::class);
        $this->app->bind('command.rpc.doc_upload', RpcDocUpload::class);
        $this->app->bind('command.rpc.doc_clean', RpcDocClean::class);

        $this->commands([
            'command.rpc.agent',
            'command.rpc.cluster',
            'command.rpc.dump.bridge',
            'command.rpc.dump.mock',
            'command.rpc.dump.sdk',
            'command.rpc.make.controller_test',
            'command.rpc.dump.js-sdk',
            'command.rpc.doc_upload',
            'command.rpc.doc_clean',
        ]);

        $this->app->singleton('rpc-server', function () {
            return RpcRouter::getInstance();
        });

        $this->app->singleton('rpc-log', function () {
            return RpcLog::getInstance();
        });

        $loader = new RpcAnnotationLoader();
        AnnotationRegistry::registerLoader([$loader, "loadClass"]);
    }
}
