<?php
/**
 * Created by PhpStorm.
 * User: liuzaisen
 * Date: 2019/4/7
 * Time: 8:33 PM
 */

namespace Mainto\RpcServer\TestHelper\Document;


use Illuminate\Contracts\Support\Arrayable;

/**
 * Class Exception
 * @package Mainto\RpcServer\TestHelper\Document
 */
class Exception implements Arrayable {
    /**
     * @var string
     */
    protected $class_name;

    /**
     * @var string
     */
    protected $title;

    /**
     * @var \Illuminate\Support\Collection
     */
    protected $infos;

    public function __construct ($class_name, $title) {
        $this->class_name = $class_name;
        $this->title = $title;
        $this->infos = collect([]);
    }

    public function addInfo ($exceptionName, $code, $message, $comment) {
        $this->infos->push([
            'exception_name' => $exceptionName,
            'code'           => $code,
            'message'        => $message,
            'comment'        => $comment,
        ]);
    }


    /**
     * Get the instance as an array.
     *
     * @return array
     */
    public function toArray () {
        return [
            'class_name' => $this->class_name,
            'title'      => $this->title,
            'infos'      => $this->infos,
        ];
    }
}