<?php
/**
 * Created by PhpStorm.
 * User: jiuli
 * Date: 2018/4/11
 * Time: 上午11:49
 */

namespace Mainto\RpcServer\RpcUtil\Stream;

use Illuminate\Database\Eloquent\Model;
use Mainto\RpcServer\RpcUtil\Block\ReturnBlock;
use Mainto\RpcServer\RpcUtil\Block\SuccessReturnBlock;

abstract class RpcStreamAbstract {
    public abstract function send ($data);

    public abstract function close ($closeParam = null);


    /**
     * 将结果转换为数据块
     * @param $ret
     * @param bool $pack
     * @param bool $rawMode
     * @return array|ReturnBlock
     */
    protected function processResult ($ret, $pack = true, $rawMode = false) {
        if ($ret instanceof Model) {
            $ret = $ret->toArray();
        } elseif ($ret instanceof ReturnBlock) {
            return $ret;
        }

        if ($pack) {
            return new SuccessReturnBlock($ret, [], $rawMode);
        } else {
            return $ret;
        }
    }
}