<?php
/**
 * Created by PhpStorm.
 * User: jiuli
 * Date: 2018/3/19
 * Time: 下午4:07
 */

namespace Mainto\RpcServer\RpcUtil\Block;

use Mainto\RpcServer\RpcUtil\RpcBlock;

class MessageInvokeControlBlock extends RpcBlock {
    protected $messageName;
    protected $params;
    protected $context;

    /**
     * MessageInvokeControlBlock constructor.
     * @param string $messageName
     * @param array $context
     * @param array $params
     */
    public function __construct (string $messageName = "", array $context = [], array $params = []) {
        parent::__construct("c", "message_invoke");

        $this->messageName = $messageName;
        $this->params = $params;
        $this->context = $context;
    }

    /**
     * 将当前Block转为数组
     * @return array
     */
    public function toArray (): array {
        return array_merge(parent::toArray(), [
            'n' => $this->messageName,
            'p' => $this->params,
            'c' => $this->context,
        ]);
    }

    /**
     * @return string
     */
    public function getMessageName (): string {
        return $this->messageName;
    }

    /**
     * @return array
     */
    public function getParams (): array {
        if (!is_array($this->params) && is_object($this->params)) {
            $this->params = collect($this->params)->toArray();
        }
        return $this->params;
    }

    /**
     * @return array
     */
    public function getContext (): array {
        return $this->context;
    }

    /**
     * 获取载荷类型
     * @return int
     */
    public function getPayloadType (): int {
        return 10;
    }

    /**
     * 设置当前数据
     * @param array $data
     */
    protected function setArray (array $data) {
        parent::setArray($data);

        $this->messageName = $data['n'] ?? '';
        $this->params = $data['p'] ?? [];
        $this->context = $data['c'] ?? [];
    }
}