<?php

namespace Mainto\RpcServer\Command;

use Doctrine\Common\Annotations\AnnotationReader;
use Illuminate\Console\Command;
use Mainto\RpcServer\RpcAnnotations\Alias;
use Mainto\RpcServer\RpcAnnotations\RpcApi;
use Mainto\RpcServer\RpcAnnotations\RpcCallWay;
use Mainto\RpcServer\RpcAnnotations\RpcParam;
use ReflectionMethod;
use RpcRouter;

class RpcSdkDump extends Command {
    use RpcEnumDump;
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'rpc:dump-mainto-sdk {--dump_path=} {--base_namespace=} {--base_enum_namespace=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'RPC Router Dumper mainto-sdk';

    /**
     * Dump IDE Start
     * ==========================================================
     */
    private $methodsMap = [];
    private $classesMap = [];
    public $dump_path;
    public $base_namespace;
    public $base_enum_namespace;
    /**
     * ===========================================================
     * Dump IDE End
     */

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct () {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     * @throws \Doctrine\Common\Annotations\AnnotationException
     * @throws \ReflectionException
     * @throws \Throwable
     */
    public function handle () {
        $dump_path = $this->option('dump_path');
        $base_namespace = $this->option('base_namespace');
        $this->dump_path = $dump_path ?: format_path('.');
        $this->base_namespace = $base_namespace ?: 'App\Rpc\Controllers\\';

        $base_enum_namespace = $this->option('base_enum_namespace');
        $this->base_enum_namespace = $base_enum_namespace ?: 'App\Enums';

        $microName = camel_case(config('rpc-server.service_name', 'NoName'));
        $microName[0] = strtoupper($microName[0]);
        $this->dumpEnum('micro-core-sdk', 'Sdk', $microName);

        if (file_exists($this->dump_path."/micro-core-sdk/src/Invokes/{$microName}")) {
            del_file_tree($this->dump_path."/micro-core-sdk/src/Invokes/{$microName}");
        }
        mkdir($this->dump_path."/micro-core-sdk/src/Invokes/{$microName}", 0777, true);
        $reader = new AnnotationReader();
        $that = &$this;
        RpcRouter::dump(function () use (&$that, $microName, $reader) {
            $dumpMap = [];
            foreach ($this->methodsMap as $name => $value) {
                /** @var ReflectionMethod $method */
                $method = $this->methodsMap[$name];
                [$className, $methodName] = explode("::", $name, 2);
                $shortClassName = $className;

                // get short class name
                if (($pos = strrpos($className, '\\')) !== false) {
                    $shortClassName = substr($className, $pos + 1);
                }

                //gen method blade

                //parse params
                $methodBlade = [];
                $methodBlade['alias'] = $methodName;
                $methodBlade['name'] = $methodName;
                $methodBlade['isDeprecated'] = false;
                $methodBlade['params'] = [];
                $continue = false;
                $hasUrl = false;
                $annotations = $reader->getMethodAnnotations($method);
                foreach ($annotations as $annotation) {
                    if ($annotation instanceof RpcCallWay && $annotation->only == 'Rpc') {
                        $continue = true;
                        break;
                    }

                    if ($annotation instanceof Alias) {
                        $methodBlade['alias'] = $annotation->name;
                    }

                    if ($annotation instanceof RpcApi) {
                        $methodBlade['url'] = $annotation->url;
                        $methodBlade['method'] = $annotation->method;
                        $hasUrl = true;
                    }

                    if ($annotation instanceof RpcParam) {
                        $tempType = $annotation->type;
                        if ($annotation->type == "uint") $annotation->type = "int";
                        if (in_array($annotation->type, ["double", "unsignedDouble"])) $annotation->type = "float";
                        if (in_array($annotation->type, ["array", "array<int>", "array<uint>", "array<string>"])) $annotation->type = "array";

                        if ($annotation->require == true || in_array('required', explode('|', $annotation->validation))) {
                            $annotation->require = true;
                            $str = "{$annotation->type} \${$annotation->name}";
                            $paramStrArr[] = $str;
                        }
                        if ($tempType != $annotation->type) {
                            $annotation->comment .= sprintf(" [Original type %s]", $tempType);
                        }

                        $methodBlade['params'][] = $annotation;
                    }
                }
                if ($continue) continue;
                if (!$hasUrl) continue;

                //find deprecated and return
                $returnType = '';
                $docComment = $method->getDocComment();
                foreach (explode("\n", $docComment) as $line) {
                    if (!$methodBlade['isDeprecated'] && strpos($line, '@deprecated') !== false) {
                        $methodBlade['isDeprecated'] = true;
                    }
                    if (!$returnType && strpos($line, '@return') !== false) {
                        $returnType = trim(str_replace(['@return', '*'], '', $line));
                    }
                }
                if (!in_array($returnType, ['int', 'array', 'string', 'float'])) {
                    $returnType = 'mixed';
                }
                $methodBlade['returnType'] = $returnType;
                $namespace = explode('\\', $this->aliasMap[get_class($this->classesMap[$className])]);
                array_pop($namespace);
                $dumpMap[substr($className, 0, -10)]['methods'][] = $methodBlade;
                $dumpMap[substr($className, 0, -10)]['namespace'] = implode('\\', $namespace);
                $dumpMap[substr($className, 0, -10)]['shortName'] = substr($shortClassName, 0, -10);
            }

            foreach ($dumpMap as $className => $item) {
                $path = $that->dump_path.("/micro-core-sdk/src/Invokes/{$microName}/".str_replace('\\', '/', $item['namespace']));
                if (!is_dir($path)) {
                    mkdir($path, 0777, true);
                }
                $item['namespace'] = $item['namespace'] ? $microName.'\\'.$item['namespace'] : $microName;
                file_put_contents("$path/{$item['shortName']}.php", "<?php\n".view('sdk-controller', [
                        'microName'      => $microName,
                        'className'      => $className,
                        'shortClassName' => $item['shortName'],
                        'methods'        => $item['methods'],
                        'namespace'      => $item['namespace'],
                    ])->render());
            }
        });
        return;
    }
}
