<?php
/**
 * Created by PhpStorm.
 * User: jiuli
 * Date: 2018/3/19
 * Time: 下午4:07
 */

namespace Mainto\RpcServer\RpcUtil\Block;

use Mainto\RpcServer\RpcUtil\RpcBlock;

class UrlInvokeControlBlock extends RpcBlock {
    protected $url;
    protected $method;
    protected $header;
    protected $params;

    /**
     * UrlInvokeControlBlock constructor.
     * @param string $method
     * @param string $url
     * @param array $header
     * @param array $params
     */
    public function __construct (string $method = "", string $url = "", array $header = [], array $params = []) {
        parent::__construct("c", "url_invoke");

        $this->url = $url;
        $this->method = $method;
        $this->params = $params;
        $this->header = $header;
    }

    /**
     * 将当前Block转为数组
     * @return array
     */
    public function toArray (): array {
        return array_merge(parent::toArray(), [
            'u' => $this->url,
            'm' => $this->method,
            'h' => $this->header,
            'p' => $this->params,
        ]);
    }

    /**
     * @return string
     */
    public function getUrl (): string {
        return $this->url;
    }

    /**
     * @return string
     */
    public function getMethod (): string {
        return $this->method;
    }

    /**
     * @return array
     */
    public function getHeader (): array {
        if (!is_array($this->header) && is_object($this->header)) {
            $this->header = collect($this->header)->toArray();
        }

        return $this->header;
    }

    /**
     * @return array
     */
    public function getParams (): array {
        if (!is_array($this->params) && is_object($this->params)) {
            $this->params = collect($this->params)->toArray();
        }
        return $this->params;
    }

    /**
     * 获取载荷类型
     * @return int
     */
    public function getPayloadType (): int {
        return 4;
    }

    /**
     * 设置当前数据
     * @param array $data
     */
    protected function setArray (array $data) {
        parent::setArray($data);

        $this->url = $data['u'] ?? '';
        $this->method = $data['m'] ?? '';
        $this->header = $data['h'] ?? [];
        $this->params = $data['p'] ?? [];
    }
}