<?php
/**
 * Created by PhpStorm.
 * User: jiuli
 * Date: 2018/3/19
 * Time: 下午4:16
 */

namespace Mainto\RpcServer\RpcUtil\Block;

use Mainto\RpcServer\RpcUtil\RpcBlock;

abstract class ReturnBlock extends RpcBlock {
    protected $message;
    protected $extend;

    /**
     * ReturnBlock constructor.
     * @param string $action
     * @param mixed $message
     * @param array $extend
     */
    public function __construct (string $action = "", $message = "", $extend = []) {
        parent::__construct("r", $action);

        $this->message = $message;
        $this->extend = $extend;
    }

    /**
     * 将当前Block转为数组
     * @return array
     */
    public function toArray (): array {
        return array_merge(
            parent::toArray(),
            ['m' => $this->message],
            $this->extend ? ['+' => $this->extend] : []
        );
    }

    /**
     * @param $key
     * @param array $extend
     */
    public function setExtend ($key, array $extend): void {
        $this->extend[$key] = $extend;
    }

    /**
     * @return mixed
     */
    public function getMessage () {
        return $this->message;
    }

    /**
     * 设置当前数据
     * @param array $data
     */
    protected function setArray (array $data) {
        parent::setArray($data);

        $this->message = $data['m'];
        $this->extend = $data['+'] ?? [];
    }
}