<?php
/**
 * Created by PhpStorm.
 * User: jiuli
 * Date: 2018/3/19
 * Time: 下午4:19
 */

namespace Mainto\RpcServer\RpcUtil\Block;

class ErrorReturnBlock extends ReturnBlock {
    private $errorCode;

    /**
     * ErrorReturnBlock constructor.
     * @param int $errorCode
     * @param string $errorMsg
     * @param array $extend
     */
    public function __construct (int $errorCode = 0, $errorMsg = "", $extend = []) {
        parent::__construct("error", $errorMsg, $extend);

        $this->errorCode = $errorCode;
    }

    /**
     * 将当前Block转为数组
     * @return array
     */
    public function toArray (): array {
        return array_merge(parent::toArray(), [
            'c' => $this->errorCode,
        ]);
    }

    /**
     * @return int
     */
    public function getErrorCode (): int {
        return $this->errorCode;
    }

    /**
     * 获取载荷类型
     * @return int
     */
    public function getPayloadType (): int {
        return 7;
    }

    /**
     * 设置当前数据
     * @param array $data
     */
    protected function setArray (array $data) {
        parent::setArray($data);

        $this->errorCode = $data['c'] ?? 0;
    }
}