<?php
/**
 * Created by PhpStorm.
 * User: jiuli
 * Date: 2018/3/19
 * Time: 下午4:07
 */

namespace Mainto\RpcServer\RpcUtil\Block;

use Mainto\RpcServer\RpcUtil\RpcBlock;

class CheckBlock extends RpcBlock {
    protected $replay;

    /**
     * CheckBlock constructor.
     * @param string $replay
     */
    public function __construct (string $replay = "") {
        parent::__construct("u", "check");

        $this->replay = $replay;
    }

    /**
     * 将当前Block转为数组
     * @return array
     */
    public function toArray (): array {
        return array_merge(parent::toArray(), [
            'r' => $this->replay,
        ]);
    }

    /**
     * @return string
     */
    public function getReplay (): string {
        return $this->replay;
    }

    /**
     * 获取载荷类型
     * @return int
     */
    public function getPayloadType (): int {
        return 2;
    }

    /**
     * 设置当前数据
     * @param array $data
     */
    protected function setArray (array $data) {
        parent::setArray($data);

        $this->replay = $data['r'] ?? '';
    }
}