<?php
/**
 * Created by PhpStorm.
 * User: jiuli
 * Date: 2018/4/11
 * Time: 上午10:17
 */

namespace Mainto\RpcServer\RpcClient;


use Mainto\RpcServer\RpcUtil\Stream\RpcStreamAbstract;
use Mainto\RpcServer\RpcUtil\Stream\RpcStreamProviderInterface;

class RpcStreamResponse {
    /**
     * Rpc 控制流
     * @var RpcStream
     */
    private $stream;

    /**
     * 内容提供者代理
     * @var RpcStreamProviderInterface
     */
    private $providerProxy = null;


    /**
     * RpcStreamResponse constructor.
     * @param RpcStream $stream
     */
    public function __construct (RpcStream $stream) {
        $this->stream = $stream;
        $this->initProxy();
    }

    /**
     * 初始化代理
     */
    private function initProxy () {
        $this->providerProxy = new class extends RpcStreamProviderInterface {
            /**
             * @var RpcStreamProviderInterface
             */
            public $proxyProvider = null;

            public function onMessageRecv (RpcStreamAbstract $stream, $message) {
                if ($this->proxyProvider) {
                    $this->proxyProvider->onMessageRecv($stream, $message);
                }
            }

            public function onStreamStart (RpcStreamAbstract $stream) {
                if ($this->proxyProvider) {
                    $this->proxyProvider->onStreamStart($stream);
                }
            }

            public function onStreamClosed ($closeData = null) {
                if ($this->proxyProvider) {
                    $this->proxyProvider->onStreamClosed($closeData);
                }
            }
        };
    }

    /**
     * 当被销毁时尝试关闭流
     */
    public function __destruct () {
        $this->stream->close();
    }

    /**
     * 获得内容提供者的代理
     * @return RpcStreamProviderInterface
     */
    public function getProviderProxy (): RpcStreamProviderInterface {
        return $this->providerProxy;
    }

    /**
     * 传入内容提供者以便流传输就绪
     * @param RpcStreamProviderInterface $provider
     */
    public function ready (RpcStreamProviderInterface $provider) {
        $this->providerProxy->proxyProvider = $provider;
        $this->stream->ready();
    }
}