<?php

use Mainto\RpcServer\RpcUtil\EtcdClient;
use MessagePack\BufferUnpacker;
use MessagePack\Packer;

if (!function_exists('var_export_min')) {
    /**
     * dump var
     *
     * @param $var
     * @param bool $return
     * @return mixed|string
     */
    function var_export_min ($var, $return = true) {
        if (is_array($var)) {
            $toImplode = [];
            foreach ($var as $key => $value) {
                $toImplode[] = var_export($key, true).' => '.var_export_min($value, true);
            }
            $code = '['.implode(',', $toImplode).']';
            if ($return) return $code;
            else echo $code;
        } else {
            return var_export($var, $return);
        }
    }
}


if (!function_exists('config_path')) {
    /**
     * Get the configuration path.
     *
     * This is a polyfill for the missing shorthand function in lumen.
     *
     * @param string $path
     * @return string
     */
    function config_path ($path = '') {
        return app()->basePath('config').($path ? DIRECTORY_SEPARATOR.$path : $path);
    }
}

if (!function_exists('msgpack_pack')) {
    /**
     * Pack message pack
     *
     * This is a polyfill for the missing msgpack extension.
     *
     * @param $msg
     * @return string
     */
    function msgpack_pack ($msg) {
        if (!isset($GLOBALS['pack'])) {
            $GLOBALS['pack'] = new Packer();
        }
        return $GLOBALS['pack']->pack($msg);
    }
}

if (!function_exists('msgpack_unpack')) {
    /**
     * Unpack message pack
     *
     * This is a polyfill for the missing msgpack extension.
     *
     * @param $data
     * @return string
     */
    function msgpack_unpack ($data) {
        if (!isset($GLOBALS['unpack'])) {
            $GLOBALS['unpack'] = new BufferUnpacker();
        }
        return $GLOBALS['unpack']->reset($data)->unpack();
    }
}

if (!function_exists('count_cpus')) {
    /**
     * Get cpu counts
     *
     * @return int
     */
    function count_cpus () {
        $numCpus = 1;
        if (is_file('/proc/cpuinfo')) {
            $cpuinfo = file_get_contents('/proc/cpuinfo');
            preg_match_all('/^processor/m', $cpuinfo, $matches);
            $numCpus = count($matches[0]);
        } else if ('WIN' == strtoupper(substr(PHP_OS, 0, 3))) {
            $process = @popen('wmic cpu get NumberOfCores', 'rb');
            if (false !== $process) {
                fgets($process);
                $numCpus = intval(fgets($process));
                pclose($process);
            }
        } else {
            $process = @popen('sysctl -a', 'rb');
            if (false !== $process) {
                $output = stream_get_contents($process);
                preg_match('/hw.ncpu: (\d+)/', $output, $matches);
                if ($matches) {
                    $numCpus = intval($matches[1][0]);
                }
                pclose($process);
            }
        }

        return intval($numCpus) <= 0 ? 1 : intval($numCpus);
    }
}

if (!function_exists('try_get_ips')) {
    /**
     * Try to get local IP
     *
     * @return array
     */
    function try_get_ips () {
        if (is_file('/proc/cpuinfo') || 'DARWIN' == strtoupper(PHP_OS)) {
            $command = "ifconfig | grep -Eo 'inet (addr:)?([0-9]*\.){3}[0-9]*' | grep -Eo '([0-9]*\.){3}[0-9]*' | grep -v '127.0.0.1'";
            $process = @popen($command, 'rb');
            if (false !== $process) {
                $output = stream_get_contents($process);
                $ips = explode("\n", trim($output));
                pclose($process);

                return $ips;
            }
            return [];
        } else if ('WIN' == strtoupper(substr(PHP_OS, 0, 3))) {
            return [];
        } else {
            return [];
        }
    }
}

if (!function_exists('get_etcd_client')) {
    /**
     * Get a ETCD Client
     *
     * @return EtcdClient
     */
    function get_etcd_client () {
        static $client = null;

        if ($client === null) {
            $client = new EtcdClient(config('rpc-server.etcd_address'));
            $client->setPretty(true);
        }

        return $client;
    }
}

if (!function_exists('get_files')) {
    /**
     * Get files
     * @param $dir
     * @return array
     */
    function get_files ($dir) {
        $files = [];
        $scan = scandir($dir);
        foreach ($scan as $item) {
            if ($item == '.' || $item == '..') continue;
            if (is_dir($dir.'/'.$item)) {
                $files = array_merge($files, get_files($dir.'/'.$item));
            } else {
                $files[] = $dir.'/'.$item;
            }
        }
        return $files;
    }
}

if (!function_exists('del_file_tree')) {
    /**
     * Delete file tree
     *
     * @param $dir
     * @return bool
     */
    function del_file_tree ($dir) {
        $files = array_diff(scandir($dir), ['.', '..']);
        foreach ($files as $file) {
            (is_dir("$dir/$file")) ? del_file_tree("$dir/$file") : unlink("$dir/$file");
        }
        return rmdir($dir);
    }
}

if (!function_exists('format_path')) {
    /**
     * Format the relative path as an absolute path with the current working directory as the reference
     *
     * @param $path
     * @return string
     */
    function format_path ($path) {
        if ($path[0] == ".") {
            $path = getcwd()."/{$path}";
        }

        $path = str_replace(['/', '\\'], DIRECTORY_SEPARATOR, $path);
        $parts = array_filter(explode(DIRECTORY_SEPARATOR, $path), 'strlen');
        $absolutes = [];
        foreach ($parts as $part) {
            if ('.' == $part) continue;
            if ('..' == $part) {
                array_pop($absolutes);
            } else {
                $absolutes[] = $part;
            }
        }
        return "/".implode(DIRECTORY_SEPARATOR, $absolutes);
    }
}

if (!function_exists('get_git_branch_version')) {
    /**
     * Format the relative path as an absolute path with the current working directory as the reference
     *
     * @param $path
     * @return string
     */
   function get_git_branch_version ($base_path = "") {
       if (!$version = env('CI_COMMIT_REF_SLUG')) {
           
           $git_file = $base_path ? $base_path.'/.git/HEAD' : base_path('/.git/HEAD');

           if (!file_exists($git_file)) {
               throw new \RuntimeException('get version fail');
           }

           $version = trim(str_replace(['ref: refs/heads/'], '', file_get_contents($git_file)));
           if (!$version) throw new \RuntimeException('get version fail');
       }
       return  $version;
   }
}