<?php
/**
 * Created by PhpStorm.
 * User: PHPStorm
 * Date: 18-12-12
 * Time: 下午2:07
 */

namespace Mainto\RpcServer\RpcUtil\SessionHandler;

use Mainto\Bridge\Invokes\CoreGear\Store;

class RpcStoreHandler implements SessionHandlerInterface {

    /**
     * 根据 sessionId 获取 session 序列化字符串
     * @param $sessionId
     * @return string|null
     */
    public function getSessionStringBySessionId ($sessionId): ?string {
        return Store::get($sessionId);
    }

    /**
     * 更新 session
     * @param $sessionId
     * @param $sessionString
     * @param $seconds
     */
    public function updateSession ($sessionId, $sessionString, $seconds): void {
        Store::set($sessionId, $sessionString, $seconds);
    }

    /**
     * 删除 session
     * @param $sessionId
     */
    public function deleteSession ($sessionId): void {
        Store::delete($sessionId);
    }
}