<?php
/**
 * Created by PhpStorm.
 * User: jiuli
 * Date: 2018/4/28
 * Time: 下午4:01
 */

namespace Mainto\RpcServer\RpcUtil;

use Generator;
use Mainto\RpcServer\Exceptions\RpcStreamException;
use Mainto\RpcServer\RpcUtil\Stream\RpcStreamAbstract;
use Mainto\RpcServer\RpcUtil\Stream\RpcStreamProviderInterface;

class RpcGeneratorStreamProxy extends RpcStreamProviderInterface {
    private $generator = null;

    /**
     * RpcGeneratorStreamProxy constructor.
     * @param Generator $generator
     */
    public function __construct (Generator $generator) {
        $this->generator = $generator;
        $this->generator->current();
    }

    public function onMessageRecv (RpcStreamAbstract $stream, $message) {
        $data = $this->generator->current();
        if ($this->generator->valid()) {
            $stream->send($data);
            $this->generator->send($message);
        } else {
            $stream->close($this->generator->getReturn());
        }
    }

    public function onStreamClosed ($closeData = null) {
        if ($this->generator->valid()) {
            $this->generator->throw(new RpcStreamException("client closed stream"));
        }
    }
}