<?php
/**
 * Created by PhpStorm.
 * User: jiuli
 * Date: 2018/3/19
 * Time: 下午4:22
 */

namespace Mainto\RpcServer\RpcUtil\Block;

class SuccessReturnBlock extends ReturnBlock {
    /**
     * SuccessReturnBlock constructor.
     * @param string $data
     * @param array $extend
     * @param $rawMode
     */
    public function __construct ($data = "", $extend = [], $rawMode = false) {
        if ($rawMode) {
            parent::__construct('success', (string)$data, $extend);
        } else {
            parent::__construct('success', json_encode($data), $extend);
        }
    }

    /**
     * 获取载荷类型
     * @return int
     */
    public function getPayloadType (): int {
        return 6;
    }

    /**
     * 设置当前数据
     * @param array $data
     */
    protected function setArray (array $data) {
        $data['m'] = json_decode($data['m'] ?? '', true);

        parent::setArray($data);
    }
}