<?php
/**
 * Created by PhpStorm.
 * User: jiuli
 * Date: 2018/4/2
 * Time: 下午1:19
 */

namespace Mainto\RpcServer\RpcServer;

use Illuminate\Contracts\Support\Arrayable;

class RpcCronItem implements Arrayable {

    private $spec;

    private $cronHookName;

    /**
     * @param string $entry
     */
    public function setEntry ($entry): void {
        $this->spec = '@'.$entry;
    }

    /**
     * @return string
     */
    public function getSpec () {
        return $this->spec;
    }

    /**
     * @param string $spec
     * @param $every
     * @param $entry
     */
    public function setSpec ($spec, $every, $entry): void {
        $every and $this->spec = '@every '.$every;
        $entry and $this->spec = '@'.$entry;
        $spec and $this->spec = str_replace('\\', '/', $spec);
    }

    /**
     * @return string
     */
    public function getCronHookName () {
        return $this->cronHookName;
    }

    /**
     * @param string $key
     */
    public function setCronHookName ($key): void {
        $this->cronHookName = 'cron-'.snake_case(config('rpc-server.service_name')).'-'.$key;
    }

    /**
     * Get the instance as an array.
     *
     * @return array
     */
    public function toArray () {
        return [
            'spec'           => $this->spec,
            'cron_hook_name' => $this->cronHookName,
        ];
    }
}