<?php
/**
 * Created by PhpStorm.
 * User: jiuli
 * Date: 2018/3/25
 * Time: 下午5:37
 */

namespace Mainto\RpcServer\RpcAnnotations;


use Doctrine\Common\Annotations\Annotation;
use Doctrine\Common\Annotations\Annotation\Attribute;
use Doctrine\Common\Annotations\Annotation\Attributes;

/**
 * Class RpcApi
 * @package Mainto\RpcServer\RpcAnnotations
 *
 * @Annotation
 * @Target({"METHOD"})
 *
 * @Attributes({
 *     @Attribute("method", type = "string"),
 *     @Attribute("url", type="string"),
 *     @Attribute("addPrefix", type="boolean"),
 * })
 */
class RpcApi {
    /**
     * 请求方法
     *
     * @Required
     * @Enum({"GET", "POST", "PUT", "DELETE", "PATCH"})
     * @var string
     */
    public $method = "GET";

    /**
     * 请求地址
     *
     * @Required
     * @var string
     */
    public $url;

    /**
     * 是否增加微服务前缀
     *
     * @var bool
     */
    public $addPrefix = true;
}