<?php

namespace Mainto\RpcServer\Command;

use Illuminate\Console\Command;
use Mainto\RpcServer\RpcServer\RpcServerWorkerMode as RpcServerHelper;

class RpcServer extends Command {
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'rpc:server {option?} {--daemon}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'RPC Server Command';

    /**
     * 可用的 Command
     * @var array
     */
    private $commands = [
        'start',
        'stop',
        'restart',
        'reload',
        'status',
        'connections',
    ];

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct () {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     * @deprecated
     */
    public function handle () {
        $command = $this->argument('option');
        $isDaemon = $this->option('daemon');

        if (!$command || !in_array($command, $this->commands)) {
            $this->comment('Usage: php artisan rpc:server {start|stop|restart|reload|status|connections} [--daemon]');
            return 1;
        }

        print "###!!!!! rpc:server is deprecated, use rpc:agent instead.\n";
        RpcServerHelper::exec($command, $isDaemon);

        return 0;
    }
}
