<?php
/**
 * Created by PhpStorm.
 * User: PHPStorm
 * Date: 8/8/18
 * Time: 6:10 PM
 */

namespace Mainto\RpcServer\RpcUtil\Tool;

use Mainto\RpcServer\RpcUtil\Tool\LogDriver\AgentSLS;
use Mainto\RpcServer\RpcUtil\Tool\LogDriver\Local;
use Mainto\RpcServer\RpcUtil\Tool\LogDriver\LogDriveAbstract;
use RuntimeException;

class RpcLog {
    protected static $instance;
    protected static $driverMap = [
        // 'aliyun' => AliyunSLS::class,
        'local' => Local::class,
        'agent' => AgentSLS::class,
    ];

    /**
     * get the log instance
     *
     * @return LogDriveAbstract
     */
    public static function getInstance () {
        if (!static::$instance) {
            $logDriver = config("rpc-server.log_driver");
            if (!isset(static::$driverMap[$logDriver])) {
                throw new RuntimeException("can not find {$logDriver} log driver");
            }

            // force local log
            if (!config('rpc-server.log_config.enable')) {
                $logDriver = 'local';
            }

            static::$instance = new static::$driverMap[$logDriver]();
        }
        return static::$instance;
    }

    /**
     * clear cache instance
     */
    public static function clearInstance () {
        static::$instance = null;
    }
}