<?php
/**
 * Created by PhpStorm.
 * User: jiuli
 * Date: 2018/7/5
 * Time: 下午5:24
 */

namespace Mainto\RpcServer\RpcServer\ContextTrait;

trait HeaderTrait {
    protected $responseHeaders = [];

    /**
     * 添加响应头
     *
     * @param $name
     * @param $value
     */
    public function addResponseHeader ($name, $value) {
        $name = strtolower($name);
        if ($name == "set-cookie") {
            if (!is_array($value)) {
                $value = [$value];
            }

            if (isset($this->responseHeaders[$name])) {
                $value = array_values(array_merge($this->responseHeaders[$name], $value));
            }
        }

        $this->responseHeaders[$name] = $value;
    }

    /**
     * 设置状态码
     *
     * @param int $statusCode
     */
    public function setStatusCode (int $statusCode) {
        $this->responseHeaders['status-code'] = (int)$statusCode;
    }

    /**
     * 跳转地址
     *
     * @param string $url
     * @param int $status
     */
    public function redirect (string $url, int $status = 302) {
        $this->setStatusCode($status);
        $this->addResponseHeader("Location", $url);
    }

    /**
     * 获取响应头
     *
     * @param $name
     * @param null $default
     * @return array
     */
    public function getResponseHeader ($name = null, $default = null) {
        if (!$name) {
            return $this->responseHeaders;
        }

        return $this->responseHeaders[$name] ?? $default;
    }
}