<?php

return [
    /**
     * Rpc Listen Address
     */
    'listen'             => env('RPC_LISTEN', '0.0.0.0'),

    /**
     * Rpc Listen Port
     */
    'port'               => env('RPC_PORT', '2233'),

    /**
     * Rpc Listen Port
     */
    'etcd_address'       => env('RPC_CONFIG', '127.0.0.1:2379'),

    /**
     * WorkMan Worker Num
     */
    'work_num'           => env('WORKER_NUM', count_cpus() * 2),

    /**
     * run in verbose mode
     */
    'verbose_mode'       => env('RPC_VERBOSE_MODE', false),

    /**
     * service name
     */
    'service_name'       => env('RPC_SERVER_NAME', 'NoName'),

    /**
     * force register local host address
     */
    'local_host_address' => env('RPC_LOCAL', null),

    /**
     * rpc log driver
     */
    'log_driver'         => env('RPC_LOG_DRIVER', in_array(config('app.env', "local"), ['dev', 'production']) ? 'agent' : 'local'),

    /**
     * session driver
     */
    'session_driver'     => env('RPC_SESSION_DRIVER', 'gear-store'),

    'gc'         => [
        /**
         * run force gc when lifetime is full
         */
        'max_lifetime' => 60,

        /**
         * run force gc probability when request is complete
         */
        'probability'  => 5,
    ],

    /**
     * rpc api url generation strategy
     */
    'url'        => [
        /**
         * enable auto add url prefix
         */
        'enable_prefix' => !env('DISABLE_URL_PREFIX', false),

        /**
         * auto add url prefix
         */
        'prefix'        => env("RPC_URL_PREFIX", "/".snake_case(env('RPC_SERVER_NAME', 'NoName'))),
    ],

    /**
     * rpc log config
     */
    'log_config' => [
        'enable' => env("MICRO_LOG_ENABLE", true),

        /**
         * aliyun sls
         */
        'aliyun' => [
            "endpoint"    => env("ALIYUN_LOG_ENDPOINT", 'cn-hangzhou.log.aliyuncs.com'),
            "accessKeyId" => env("ALIYUN_LOG_ACCESSKEYID", 'LTAIhyOywixcFaGt'),
            "accessKey"   => env("ALIYUN_LOG_ACCESSKEY", 'CzkbzNy0Tfz85J5Hk8GgCQJeSPVF2N'),
            "project"     => env("ALIYUN_LOG_MICRO", 'micro-local'),
        ],
    ],

    /**
     * micro doc config
     */
    'micro_doc'  => [
        'enable'     => env("MICRO_DOC_ENABLE", false),
        'doc_dir'    => env("MICRO_DOC_DIR", storage_path('app/')),
        'path_begin' => env("MICRO_DOC_PATH_BEGIN", 'App\Rpc'),
        'doc_domain' => env('MICRO_DOC_DOMAIN', 'https://doc.local.hzmantu.com'),
    ],

    /**
     * cron config
     */
    'cron'       => [
        'enable' => env('CRON_ENABLE', true),
    ],

    /**
     * rabbitmq config
     */
    'rabbit_mq'  => [
        'enable'   => env('RABBITMQ_ENABLE', true),
        'host'     => env('RABBITMQ_HOST', 'localhost'),
        'port'     => env('RABBITMQ_PORT', 5672),
        'username' => env('RABBITMQ_USERNAME', 'guest'),
        'password' => env('RABBITMQ_PASSWORD', 'guest'),
    ],

    /**
     * agent config (can rewrite by env)
     */
    'agent'      => [
        'debug'              => config('app.debug'),
        'verbose'            => env('RPC_VERBOSE_MODE', false),
        'etcd_config_server' => env('RPC_CONFIG', '127.0.0.1:2379'),

        'enable_setting_client' => env('RPC_SETTING', false),
        'enable_log_file'       => true,
        'enable_watch_reload'   => config('app.env') == "local",
        'watch_reload_dir'      => '',
        'log_file_dir'          => '$runtime_dir/log/$year-$month-$day',
        'log_file_name'         => '$hour$minute$second-$worker_id.log',

        'tool_serve_addr'  => '0.0.0.0',
        'tool_serve_port'  => env('PHP_AGENT_DEBUG_SERVE_PORT', '0'),
        'outer_serve_addr' => '0.0.0.0',
        'outer_serve_port' => env('RPC_PORT', '2233'),
        'inner_serve_addr' => '127.0.0.1',

        'min_worker_num' => 1,
        'max_worker_num' => 20,

        'worker_gc_time'         => 30,
        'max_worker_process'     => 5000,
        'max_worker_idle_second' => 300,
        'max_worker_life_second' => 3600,
        'max_worker_busy_second' => 300,
    ],
];
