<?php
/**
 * Created by PhpStorm.
 * User: jiuli
 * Date: 2018/4/7
 * Time: 下午3:16
 */

namespace Mainto\RpcServer\RpcServer\ContextTrait;

use Mainto\RpcServer\RpcUtil\Block\UrlInvokeControlBlock;

trait RpcUrlTrait {
    private $header = null;

    /**
     * 是否是从proxy转发来的请求
     *
     * @return bool
     */
    public function isRpcUrlRequest () {
        return $this->rpcBlock instanceof UrlInvokeControlBlock;
    }

    /**
     * 是否有头信息
     *
     * @param $key
     * @return bool
     */
    public function hasHeader ($key) {
        if ($this->rpcBlock instanceof UrlInvokeControlBlock) {
            if ($this->header === null) {
                $this->header = $this->rpcBlock->getHeader();
            }

            return isset($this->header[$key]);
        }
        return false;
    }

    /**
     * 获取当前的用户ID
     * @return null
     */
    public function getSessionId () {
        return $this->getHeader('X-Auth-StreamId');
    }

    /**
     * 获取每个头信息
     * @param $key
     * @return null
     */
    public function getHeader ($key) {
        if ($this->rpcBlock instanceof UrlInvokeControlBlock) {
            if ($this->header === null) {
                $this->header = $this->rpcBlock->getHeader();
            }

            return $this->header[$key] ?? null;
        }
        return null;
    }
}