<?php
/**
 * Created by PhpStorm.
 * User: jiuli
 * Date: 2018/4/2
 * Time: 下午1:19
 */

namespace Mainto\RpcServer\RpcServer;


use Illuminate\Contracts\Support\Arrayable;

class RpcUrlCollectItem implements Arrayable {
    private $url;
    private $method;
    private $headers = [];
    private $responseHeader = [];
    private $format = "json";
    private $needAuthority = [];
    private $messageHookName = null;

    /**
     * @return mixed
     */
    public function getUrl () {
        return $this->url;
    }

    /**
     * @param mixed $url
     */
    public function setUrl ($url): void {
        $this->url = $url;
    }

    /**
     * @return mixed
     */
    public function getMethod () {
        return $this->method;
    }

    /**
     * @param mixed $method
     */
    public function setMethod ($method): void {
        $this->method = $method;
    }

    /**
     * @return mixed
     */
    public function getHeaders () {
        return $this->headers;
    }

    /**
     * @param string $header
     */
    public function addHeader (string $header): void {
        $this->headers[] = $header;
    }

    /**
     * @return mixed
     */
    public function getResponseHeaders () {
        return $this->responseHeader;
    }

    /**
     * @param string $name
     * @param string $value
     */
    public function addResponseHeader (string $name, string $value): void {
        $this->responseHeader[$name] = $value;
    }

    /**
     * @param string $name
     */
    public function addAuthority (string $name): void {
        $this->needAuthority[] = $name;
    }

    /**
     * @return string
     */
    public function getFormat (): string {
        return $this->format;
    }

    /**
     * @param string $format
     */
    public function setFormat (string $format): void {
        $this->format = $format;
    }

    /**
     * @return null
     */
    public function getMessageHookName () {
        return $this->messageHookName;
    }

    /**
     * @param null $messageHookName
     */
    public function setMessageHookName ($messageHookName): void {
        $this->messageHookName = $messageHookName;
    }

    public function toArray () {
        return [
            'method'            => $this->method,
            'url'               => $this->url,
            'headers'           => $this->headers,
            'format'            => $this->format,
            'response_header'   => $this->responseHeader,
            'need_authority'    => $this->needAuthority,
            'message_hook_name' => $this->messageHookName,
        ];
    }
}