<?php

namespace Mainto\RpcServer\Command;

use Illuminate\Console\Command;
use Mainto\RpcServer\TestHelper\Document\Document;
use Mainto\RpcServer\TestHelper\Document\Group;
use Mainto\RpcServer\TestHelper\Document\GroupApi;
use Mainto\RpcServer\TestHelper\Document\GroupApiRequestExample;

class RpcMockDump extends Command {
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'rpc:mock {--file_path=} {--dump_path=} {--write_json=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'RPC Router Dumper mock';

    /**
     * @var Document
     */
    protected $document;

    /**
     * 初始化文档信息
     */
    private function initDocument () {
        if (!$file_path = $this->option('file_path')) {
            $file_path = config('rpc-server.micro_doc.doc_dir').'/micro_document.json';
        }

        if (file_exists($file_path)) {
            $this->document = unserialize(file_get_contents($file_path));
        } else {
            $this->document = Document::getInstance();
        }
    }

    /**
     * Execute the console command.
     *
     * @throws \Throwable
     */
    public function handle () {
        $this->initDocument();

        $this->document->getApi()->each(function (Group $group) {
            $group->getGroupApi()->each(function (GroupApi $groupApi) {
                // 准备数据
                $fileName = substr($groupApi->getBridgeNamespace(), 23);
                [$serviceName, $controllerName] = explode("\\", $fileName, 2);
                $configName = str_replace("\\", "/", $controllerName)."/{$groupApi->getMethodName()}".".json";
                $config = $groupApi->getRequestExample()->mapWithKeys(function (GroupApiRequestExample $requestExample, $i) {
                    return [$i + 1 => $requestExample->getResponse()];
                });

                // 创建文件夹
                if (!file_exists(dirname($configName))) {
                    mkdir(dirname($configName), 0777, true);
                }

                // 写入数据
                print "write $configName\n";
                file_put_contents($configName, json_encode($config, JSON_PRETTY_PRINT));
            });
        });

        print "write success\n";
    }
}
