<?php
/**
 * Created by PhpStorm.
 * User: jiuli
 * Date: 2018/3/19
 * Time: 下午4:07
 */

namespace Mainto\RpcServer\RpcUtil\Block;

use Mainto\RpcServer\RpcUtil\RpcBlock;

class InvokeControlBlock extends RpcBlock {
    protected $class;
    protected $method;
    protected $params;

    /**
     * InvokeControlBlock constructor.
     * @param string $class
     * @param string $method
     * @param array $params
     */
    public function __construct (string $class = "", string $method = "", array $params = []) {
        parent::__construct("c", "invoke");

        $this->class = $class;
        $this->method = $method;
        $this->params = $params;
    }

    /**
     * 将当前Block转为数组
     * @return array
     */
    public function toArray (): array {
        return array_merge(parent::toArray(), [
            'c' => $this->class,
            'm' => $this->method,
            'p' => $this->params,
        ]);
    }

    /**
     * @return string
     */
    public function getClass (): string {
        return $this->class;
    }

    /**
     * @return string
     */
    public function getMethod (): string {
        return $this->method;
    }

    /**
     * @return array
     */
    public function getParams (): array {
        return $this->params;
    }

    /**
     * 获取载荷类型
     * @return int
     */
    public function getPayloadType (): int {
        return 3;
    }

    /**
     * 设置当前数据
     * @param array $data
     */
    protected function setArray (array $data) {
        parent::setArray($data);

        $this->class = $data['c'] ?? '';
        $this->method = $data['m'] ?? '';
        $this->params = $data['p'] ?? [];
    }
}